# 마이크로서비스 아키텍처(MSA)
>마이크로서비스란 작고, 독립적으로 배포 가능한 각각의 기능을 수행하는 서비스로 구성된 프레임워크라고 할 수 있다. 마이크로서비스는 완전히 독립적으로 배포가 가능하고, 다른 기술 스택(개발 언어, 데이터베이스 등)이 사용 가능한 단일 사업 영역에 초점을 둔다.

## **MSA가 등장한 배경**  
<img width="703" alt="스크린샷 2022-12-24 오후 9 50 35" src="https://user-images.githubusercontent.com/70997596/209437238-51fa736a-ab57-43fe-a5f3-5ea50f4d10e0.png">


기존의 서비스들은 **Monolithic 아키텍처** 를 사용했었다.  
Monolithic 아키텍처는 소프트웨어의 모든 구성요소가 한 프로젝트에 통합되어 있는 형태이다.  
웹 프로그램을 개발하기 위해 모듈별로 개발을 하고, 개발이 완료된 웹 어플리케이션을 하나의 결과물로 패키징하여 배포되는 형태를 말한다. 이런 어플리케이션을 모놀리식 어플리케이션이라 하며, 웹의 경우 WAR파일로 빌드되어 WAS에 배포하는 형태를 말한다. 주로 소규모 프로젝트에서 사용된다.

하지만 일정 규모 이상의 서비스, 혹은 수백명 이상의 개발자가 투입되는 프로젝트에서 모놀리틱 구조는 한계를 보인다. 

- **부분 장애가 전체 서비스의 장애로 확대될 수 있다.**  
    - 개발자의 잘못된 코드 배포 또는 갑작스런 트래픽 증가로 인해 성능에 문제가 생겼을 때, 서비스 전체의 장애로 확대될 수 있다.
- **부분적인 *Scale-out(여러 server로 나누어 일을 처리하는 방식)이 어렵다.** 
    - Monolithic Architecture에서는 사용되지 않는 다른 모든 서비스가 Scale-out되어야 하기 때문에 부분 Scale-out이 어렵다.
- **서비스의 변경이 어렵고, 수정 시 장애의 영향도 파악이 힘들다.**  
    - 여러 컴포넌트가 하나의 서비스에 강하게 결합되어 있기 때문에 수정에 대한 영향도 파악이 힘들다.
- **배포 시간이 오래 걸린다.**  
    - 최근 어플리케이션 개발 방법은 CI/CD를 통한 개발부터 배포까지 빠르게 반영하는 추세이다. 그러나 규모가 커짐에 따라 작은 변경에도 높은 수준의 테스트 비용이 발생하기도 하며, 많은 사람이 하나의 시스템을 개발하여 배포하기 때문에 영향을 줄 수 밖에 없다.
- **한 Framework와 언어에 종속적이다.** 
    - Spring framework를 사용할 경우, blockchain 연동 모듈을 추가할 때 node.js를 사용하는 것이 일반적이며 강세이다. 그러나 java를 이용하여 해당 모듈을 작성할 수 밖에 없다. 선정했던 framework가 Spring이기 때문이다.

이러한 Monolithic Architecture의 문제점들을 보완하기 위해 MSA가 등장하게 되었다.  
기존의 특정한 물리적인 서버에 서비스를 올리던 on-promise 서버 기반의 Monolithic Architecture에서 이제는 클라우드 환경을 이용하여 서버를 구성하는 MicroService Architecture로 많은 서비스들이 전환되고 있다. 

## **MSA의 특징** 

- 전체 어플리케이션을 특정 목적을 가진 어플리케이션 단위로 나누는 것이다. 나누어진 어플리케이션은 다른 어플리케이션과 약한 결합도와 강한 응집도를 목표로 한다.
- 나누어진 어플리케이션으로 독립된 서비스를 제공하더라도 문제가 없어야 하는 것을 의미한다.
- 잘 정의된 API를 사용하여 통신한다. 응답으로 주어진 결과물을 신뢰한다.
- 어플리케이션을 독립적으로 배포 가능하다.

## MSA의 구조
MSA애는 표준이라고 할 수 있는 구조는 없지만 보편적으로 사용되는 형태는 분명히 존재한다.

<br>

<img width="400" alt="스크린샷 2022-12-24 오후 9 50 35" src="https://github.com/da-in/tech-interview-study/assets/79582366/52f493cf-9dd1-40a1-997f-4f1ffad16b90">

일반적으로 사용되는 MSA의 구조
<br>
<br>
1. API Gateway

사용자는 하나의 ip로 요청을 보내지만,API Gateway를 통해 각 분산된 어플리케이션에 맞는 IP로 변환된다.

2. Service Discovery

API Gateway를 통해 넘어온 요청을 각 분산된 서비스로 넘겨주는 역할을 한다. 얼핏보면 비슷한 역할이지만, ip가 아닌 이름, ID로도 호출할 수 있고, 관리 측면에서 API Gateway보다 유용하다.

3. Service Mesh

마이크로 서비스 간의 통신(네트워크)를 담당하는 인프라 계층이다. 상호 통신을 위해 Service Discovery,Service Routing,Failure Recovery,Load Balancing,보안 등의 문제를 처리할 기능을 포함하고 있다.

4. Container Management

컨테이너 수준에서 각 서비스 어플리케이션이 구동된다. 각자 OS를 갖고 있는 VM과 달리 커널을 공유하고 있으므로 자원 측면에서 이득을 볼 수 있다. MSA 프로젝트는 여러 컨테이너들로 구성되므로 컨테이너 오케스트레이션 기술이 필요하다. (ex.쿠버네티스)

etc.
MSA를 잘 구현하기 위해서는 기존의 모놀로식 아키텍처에서 사용하던 레이어드 아키텍처보다는 클린 아키텍처, 헥사고날 아키텍처 등 확장에 보다 유연한 구조로 프로젝트를 설계하는것이 유리하다는 의견이 많다.
또한 DDD를 통해 도메인을 구분하고, 그에 따라서 데이터베이스도 분리하는것이 적절하다고 한다.

**MSA 장점**

- 각각의 서비스는 모듈화가 되어있으며 이러한 모듈까리는 RPC 또는 message-driven API등을 이용하여 통신한다. 이러한 MSA는 각각 개별의 서비스 개발을 빠르게 하며, 유지보수도 쉽게할 수 있도록 한다.  
- 팀 단위로 적절한 수준에서 기술 스택을 다르게 가져갈 수 있다. 회사가 java의 spring 기반이라도 MSA를 적용하면 node.js로 블록체인 개발 모듈을 연동함에 무리가 없다.   
- 마이크로서비스는 서비스별로 독립적 배포가 가능하다. 따라서 지속적인 배포 CD도 모놀로식에 비해서 가볍게 할 수 있다.  
- 마이크로서비스는 각각 서비스의 부하에 따라 개별적으로 scale-out이 가능하다. 메모리, CPU적으로 상당부분 이득이 된다.

**MSA 단점**

- MSA는 모놀리식에 비해 상대적으로 많이 복잡하다. 서비스가 모두 분산되어 있기 때문에 개발자는 내부 시스템의 통신을 어떻게 가져가야 할지 정해야한다. 또한, 통신의 장애와 서버의 부하 등이 있을 경우 어떻게 transaction을 유지할지 결정하고 구현해야한다. 
- 모놀리식에서는 단일 트랜잭션을 유지하면 됐지만 MSA에서는 비즈니스에 대한 DB를 가지고 있는 서비스도 각기 다르고, 서비스의 연결을 위해서는 통신이 포함되기 때문에 트랜잭션을 유지하는게 어렵다. 트랜잭션은 DB가 아니라 어플리케이션 단에서 구현해야하는 경우가 생긴다.
- 기존의 단일 DB에서는 외래키를 통해 조인하고, 외래키를 통한 무결성 제약조건을 이용할 수 있었고, ORM을 이용하면 연관관계를 편리하게 구성할 수 있었지만, DB가 분리되면 이러한 장점들도 이용 불가능 하다.
- DB가 분리되어 있기 때문에 정합성 문제도 발생한다. 이를 위해 여러 방법이 있으며, 카프카와 같은 이벤트 브로커를 이용해 DB간의 정합성을 구현하는 방법이 존재한다.
- 통합 테스트가 어렵다. 개발 환경과 실제 운영환경을 동일하게 가져가는 것이 쉽지 않다. 
- 실제 운영환경에 대해서 배포하는 것이 쉽지 않다. 마이크로서비스의 경우 서비스 1개를 재배포 한다고 하면 다른 서비스들과의 연계가 정상적으로 이루어지고 있는지도 확인해야한다. 
